package ga.view.examples.simple;

import ga.core.goperators.IMutationOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.validation.GAContext;

/**
 * Mutation operator for the simple object example.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SimpleObjectMutationOp extends ProbabilityOp implements
    IMutationOp<SimpleObjectIndividual> {

  /**
   * Instantiates a new simple object mutation op.
   * 
   * @param pMutate
   *          the mutate
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public SimpleObjectMutationOp(final int pMutate) {
    super(pMutate);
  }

  @Override
  public SimpleObjectIndividual mutate(final SimpleObjectIndividual individual,
      final GAContext context) {
    final SimpleObjectIndividual ind = individual.clone();

    if (doOperate()) {
      final int iMutate = getRandom().nextInt(
          SimpleObjectIndividual.NUM_PARAMETERS);

      if (iMutate == SimpleObjectIndividual.PARAMETER_TYPE) {
        final int oldNum = (Integer) ind.getGenotype().get(iMutate);
        final int newNum = (oldNum + getRandom().nextInt(
            SimpleObjectIndividual.TYPE_COUNT))
            % SimpleObjectIndividual.TYPE_COUNT;
        ind.getGenotype().set(iMutate, newNum);
      } else {
        final float oldNum = (Float) ind.getGenotype().get(iMutate);
        final float newNum = (oldNum + getRandom().nextFloat()) % 1f;
        ind.getGenotype().set(iMutate, newNum);
      }
    }

    return ind;
  }

}
